import {createReducer} from 'typesafe-actions';

import {IAviaRouteResponse} from 'types/avia/landing/route/IAviaRoute';

import {
    getRouteDataActions,
    IAviaRequestRouteDataAction,
    TAviaRouteActions,
} from 'reducers/avia/route/actions';

export interface IAviaRouteStore {
    isLoading: boolean;
    isFetched: boolean;
    isError: boolean;
    isNotFound: boolean;
    requestParams: IAviaRequestRouteDataAction | null;
    data?: IAviaRouteResponse;
}

const INITIAL_STATE: IAviaRouteStore = {
    isLoading: false,
    isFetched: false,
    isError: false,
    isNotFound: false,
    requestParams: null,
};

export default createReducer<IAviaRouteStore, TAviaRouteActions>(INITIAL_STATE)
    .handleAction(getRouteDataActions.request, (state, {payload}) => ({
        ...state,
        isLoading: true,
        isFetched: false,
        isError: false,
        isNotFound: false,
        requestParams: payload,
    }))
    .handleAction(getRouteDataActions.success, (state, {payload}) => ({
        ...state,
        data: payload,
        isLoading: false,
        isFetched: true,
        isNotFound: false,
        isError: false,
    }))
    .handleAction(getRouteDataActions.failure, (state, {payload}) => {
        if (payload === 404) {
            return {
                isLoading: false,
                isFetched: false,
                isNotFound: true,
                isError: true,
                requestParams: null,
            };
        }

        return {
            isLoading: false,
            isFetched: false,
            isNotFound: false,
            isError: true,
            requestParams: null,
        };
    });
