import {Request} from '@yandex-data-ui/core/lib/types';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {getRouteDataActions} from 'reducers/avia/route/actions';

import {isUnknownAxiosError} from 'utilities/error';

import {aviaRouteProvider} from 'serviceProvider/avia/aviaRouteProvider';

interface IFetchPopularDirectionsAction {
    req?: Request;
    fromSlug: string;
    toSlug: string;
}

export const requestRouteDataThunkAction = ({
    req,
    fromSlug,
    toSlug,
}: IFetchPopularDirectionsAction): CustomThunkAction<void> => {
    return async (dispatch, getState): Promise<void> => {
        try {
            const {
                avia: {
                    aviaRoute: {requestParams: prevRequestParams},
                },
            } = getState();

            if (
                prevRequestParams &&
                prevRequestParams.fromSlug === fromSlug &&
                prevRequestParams.toSlug === toSlug
            ) {
                return;
            }

            dispatch(
                getRouteDataActions.request({
                    fromSlug,
                    toSlug,
                }),
            );

            const data = await aviaRouteProvider
                .provider(req?.container)
                .getRouteData({
                    fromSlug,
                    toSlug,
                });

            dispatch(getRouteDataActions.success(data));
        } catch (error) {
            const status = isUnknownAxiosError(error)
                ? error.response?.status
                : undefined;

            dispatch(getRouteDataActions.failure(status ?? null));
        }
    };
};
