import {createAction} from 'typesafe-actions';

import {
    IAviaTDAnswer,
    IProgress,
} from 'server/api/AviaTicketDaemonApi/types/IAviaTDAnswer';
import {EAviaInitSearchError} from 'types/avia/search/EAviaInitSearchError';
import {IAviaParams} from 'server/services/AviaSearchService/types/IAviaParams';

import {IAviaSearchResultsSorting} from 'reducers/avia/search/results/reducer';
import {normalizeTDAnswer} from 'reducers/avia/utils/ticketDaemon/normalizeTDAnswer';

import {IRumUiContext} from 'contexts/RumUiContext';

import {IPartner} from 'server/api/AviaPartnersApi/AviaPartnersApi';

export const setTDAnswer = createAction(
    'avia/search/results/SET_TD_ANSWER',
    (payload: IAviaTDAnswer) => normalizeTDAnswer(payload),
)();

export const resetSearch = createAction('avia/search/results/RESET_SEARCH')();

export const resetSearchKey = createAction(
    'avia/search/results/RESET_SEARCH_KEY',
)();

export const initSearch = createAction('avia/search/results/INIT_SEARCH')<{
    query: IAviaParams;
    rumUi: IRumUiContext;
}>();

export const initSearchSuccess = createAction(
    'avia/search/results/INIT_SEARCH_SUCCESS',
)<{id: string}>();

export const initSearchFail = createAction(
    'avia/search/results/INIT_SEARCH_FAIL',
)<Nullable<EAviaInitSearchError>>();

export const setResultsSorting = createAction(
    'avia/search/results/SET_SORT_TYPE',
)<IAviaSearchResultsSorting>();

export const stopSearch = createAction('avia/search/results/STOP_SEARCH')();

export const updateAviaSearchProgress = createAction(
    'avia/search/results/UPDATE_PROGRESS',
)<IProgress>();

export const fetchPartnersInfo = createAction(
    'avia/search/results/FETCH_PARTNERS_INFO',
)();
export const setPartnersInfo = createAction(
    'avia/search/results/SET_PARTNERS_INFO',
)<Record<string, IPartner>>();
