import {ActionType, createAction} from 'typesafe-actions';

import {
    TAviaFilterKey,
    EAviaSearchTransferFilter,
    IAviaSearchResultsFilters,
    IAviaSearchTimeFilter,
    TAviaSearchCompanyFilter,
    TAviaSearchPartnersFilter,
    TAviaSearchTransferRange,
    IAviaSearchPlusPointsFilter,
    IAviaSearchSegmentsDirectionAirportsFilter,
    IAviaSearchSegmentsTransferAirportsFilter,
} from 'reducers/avia/search/results/filters/reducer';

import {Flag} from 'utilities/flags/flags';
import IPrice from 'utilities/currency/PriceInterface';

export const setBaggageFilter = createAction(
    'avia/search/filter/SET_BAGGAGE',
)<boolean>();

export const setTransferFilter = createAction(
    'avia/search/filter/SET_TRANSFER',
)<Flag<EAviaSearchTransferFilter>>();

export const setTransferRangeFilter = createAction(
    'avia/search/filter/SET_TRANSFER_RANGE',
)<TAviaSearchTransferRange | null>();

export const setTimeFilter = createAction('avia/search/filter/SET_TIME_FILTER')<
    IAviaSearchTimeFilter[]
>();

export const setCompanyFilter = createAction(
    'avia/search/filter/SET_COMPANY',
)<TAviaSearchCompanyFilter>();

export const setDirectionAirportsFilter = createAction(
    'avia/search/filter/SET_DIRECTION_AIRPORTS',
)<IAviaSearchSegmentsDirectionAirportsFilter[]>();

export const setTransferAirportsFilter = createAction(
    'avia/search/filter/SET_TRANSFER_AIRPORTS',
)<IAviaSearchSegmentsTransferAirportsFilter[]>();

export const setPriceFilter = createAction(
    'avia/search/filter/SET_PRICE_FILTER',
)<IPrice>();

export const setPartnersFilter = createAction(
    'avia/search/filter/SET_PARTNERS',
)<TAviaSearchPartnersFilter>();

export const setPlusPointsFilter = createAction(
    'avia/search/filter/SET_PLUS_POINTS_FILTER',
)<IAviaSearchPlusPointsFilter>();

export const setFilterValues = createAction('avia/search/filter/SET_VALUES')<
    Partial<IAviaSearchResultsFilters>
>();

export const resetFilterValue = createAction(
    'avia/search/filter/RESET_VALUE',
)<TAviaFilterKey>();

export const resetDirectionAirportsFilter = createAction(
    'avia/search/filter/RESET_DIRECTION_AIRPORTS',
)();

export const resetTransferAirportsFilter = createAction(
    'avia/search/filter/RESET_TRANSFER_AIRPORTS',
)();

export const resetTransferFilter = createAction(
    'avia/search/filter/RESET_TRANSFER',
)();

export const resetFilterValues = createAction(
    'avia/search/filter/RESET_VALUES',
)();

const baseFilterActions = {
    setTimeFilter,
    setPriceFilter,
    setBaggageFilter,
    setTransferFilter,
    setPartnersFilter,
    setDirectionAirportsFilter,
    setTransferAirportsFilter,
    setCompanyFilter,
    setTransferRangeFilter,
    setPlusPointsFilter,
    resetFilterValue,
    resetDirectionAirportsFilter,
    resetTransferAirportsFilter,
    resetTransferFilter,
};

export type TAviaBaseFilterAction = ActionType<typeof baseFilterActions>;
