import {isEqual} from 'lodash';
import {batchActions} from 'redux-batched-actions';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {TAviaBaseFilterAction} from 'reducers/avia/search/results/filters/actions';
import filtersReducer from 'reducers/avia/search/results/filters/reducer';

import {getAviaSearchFilters} from 'selectors/avia/search/aviaSearchResultsSelector';

export const flushAviaFilters =
    (actions: TAviaBaseFilterAction[]): CustomThunkAction<void> =>
    (dispatch, getState) => {
        const filters = getAviaSearchFilters(getState());

        dispatch(
            batchActions([
                ...actions.filter(
                    action =>
                        !isEqual(filters, filtersReducer(filters, action)),
                ),
            ]),
        );
    };
