import {createReducer, ActionType} from 'typesafe-actions';

import {RemoteResourceStatus} from 'reducers/avia/data-types';

import {partnersFetchActions} from './actions';

export interface IAviaPopularPartnersState {
    state: RemoteResourceStatus;
    data: string[];
}

export function getInitialState(): IAviaPopularPartnersState {
    return {
        state: 'INIT',
        data: [],
    };
}

export default createReducer<
    IAviaPopularPartnersState,
    ActionType<typeof partnersFetchActions>
>(getInitialState())
    .handleAction(partnersFetchActions.request, () => ({
        state: 'FETCHING',
        data: [],
    }))
    .handleAction(partnersFetchActions.success, (_, {payload}) => ({
        state: 'READY',
        data: payload,
    }))
    .handleAction(partnersFetchActions.failure, () => ({
        state: 'ERROR',
        data: [],
    }));
