import {createReducer, ActionType} from 'typesafe-actions';

import {IAviaTopFlights} from 'server/services/AviaSearchService/types/IAviaTopFlights';

import {RemoteResourceStatus} from 'reducers/avia/data-types';

import {flightsFetchActions} from './actions';

export interface IAviaPopularFlightsState {
    state: RemoteResourceStatus;
    data: IAviaTopFlights;
}

const getInitialData = (): IAviaTopFlights => ({
    forward: [],
    backward: [],
    forward2: [],
    backward2: [],
});

export function getInitialState(): IAviaPopularFlightsState {
    return {
        state: 'INIT',
        data: getInitialData(),
    };
}

export default createReducer<
    IAviaPopularFlightsState,
    ActionType<typeof flightsFetchActions>
>(getInitialState())
    .handleAction(flightsFetchActions.request, () => ({
        state: 'FETCHING',
        data: getInitialData(),
    }))
    .handleAction(flightsFetchActions.success, (state, {payload}) => ({
        state: 'READY',
        data: payload,
    }))
    .handleAction(flightsFetchActions.failure, state => ({
        ...state,
        state: 'ERROR',
    }));
