import {createReducer, ActionType} from 'typesafe-actions';

import * as subscriptionActions from 'reducers/avia/search/subscription/actions';

const {
    setSubscription,
    resetSubscription,
    setConfirmationStatus,
    setUnsubscribeStatus,
} = subscriptionActions;

export interface IAviaSubscription {
    id: string;
    needConfirmation: boolean | null;
    unsubscribedSuccessfully: boolean;
}

const INITIAL_STATE: IAviaSubscription = {
    id: '',
    needConfirmation: null,
    unsubscribedSuccessfully: true,
};

export default createReducer<
    IAviaSubscription,
    ActionType<typeof subscriptionActions>
>(INITIAL_STATE)
    .handleAction(setSubscription, (state, {payload}) => ({
        ...state,
        id: payload,
    }))
    .handleAction(setConfirmationStatus, (state, {payload}) => ({
        ...state,
        needConfirmation: payload,
    }))
    .handleAction(setUnsubscribeStatus, (state, {payload}) => ({
        ...state,
        unsubscribedSuccessfully: payload,
    }))
    .handleAction(resetSubscription, () => INITIAL_STATE);
