import {ActionType, createAction} from 'typesafe-actions';

import {IAviaSearchFormPointField} from 'projects/avia/components/SearchForm/types';
import {EAviaClassType} from 'types/avia/EAviaClassType';

export const setAviaSearchFormFromFieldAction = createAction(
    'AVIA.SEARCH_FORM.SET_FROM',
)<IAviaSearchFormPointField>();
export const setAviaSearchFormToFieldAction = createAction(
    'AVIA.SEARCH_FORM.SET_TO',
)<IAviaSearchFormPointField>();
export const setAviaSearchFormStartDateFieldAction = createAction(
    'AVIA.SEARCH_FORM.SET_START_DATE',
)<string | null>();
export const setAviaSearchFormEndDateFieldAction = createAction(
    'AVIA.SEARCH_FORM.SET_END_DATE',
)<string | null>();
export const setAviaSearchFormIsRoundTripFieldAction = createAction(
    'AVIA.SEARCH_FORM.SET_IS_ROUND_TRIP',
)<boolean>();
export const setAviaSearchFormAdultsFieldAction = createAction(
    'AVIA.SEARCH_FORM.SET_ADULTS',
)<number>();
export const setAviaSearchFormChildrenFieldAction = createAction(
    'AVIA.SEARCH_FORM.SET_CHILDREN',
)<number>();
export const setAviaSearchFormInfantsFieldAction = createAction(
    'AVIA.SEARCH_FORM.SET_INFANTS',
)<number>();
export const setAviaSearchFormAviaClassFieldAction = createAction(
    'AVIA.SEARCH_FORM.SET_AVIA_CLASS',
)<EAviaClassType>();

const reducerActions = {
    setAviaSearchFormFromFieldAction,
    setAviaSearchFormToFieldAction,
    setAviaSearchFormStartDateFieldAction,
    setAviaSearchFormEndDateFieldAction,
    setAviaSearchFormIsRoundTripFieldAction,
    setAviaSearchFormAdultsFieldAction,
    setAviaSearchFormChildrenFieldAction,
    setAviaSearchFormInfantsFieldAction,
    setAviaSearchFormAviaClassFieldAction,
};

export type TAviaSearchFormActions = ActionType<typeof reducerActions>;
