import {createReducer} from 'typesafe-actions';

import {
    DEFAULT_ADULTS_COUNT,
    DEFAULT_AVIA_CLASS,
    DEFAULT_INFANTS_COUNT,
    DEFAULT_CHILDREN_COUNT,
} from 'constants/avia';

import {ESearchFormFieldName} from 'components/SearchForm/types';
import {IAviaSearchFormValues} from 'projects/avia/components/SearchForm/types';

import {
    setAviaSearchFormAdultsFieldAction,
    setAviaSearchFormAviaClassFieldAction,
    setAviaSearchFormInfantsFieldAction,
    setAviaSearchFormChildrenFieldAction,
    setAviaSearchFormEndDateFieldAction,
    setAviaSearchFormFromFieldAction,
    setAviaSearchFormIsRoundTripFieldAction,
    setAviaSearchFormStartDateFieldAction,
    setAviaSearchFormToFieldAction,
    TAviaSearchFormActions,
} from 'reducers/avia/searchForm/actions';

import {ESuggestSource} from 'components/SearchSuggest/SearchSuggest';

const INITIAL_STATE: IAviaSearchFormValues = {
    [ESearchFormFieldName.FROM]: {
        selectedValue: false,
        inputValue: '',
        source: ESuggestSource.INPUT,
    },
    [ESearchFormFieldName.TO]: {
        selectedValue: false,
        inputValue: '',
        source: ESuggestSource.INPUT,
    },
    [ESearchFormFieldName.START_DATE]: null,
    [ESearchFormFieldName.END_DATE]: null,
    isRoundTrip: true,
    adults: DEFAULT_ADULTS_COUNT,
    children: DEFAULT_CHILDREN_COUNT,
    infants: DEFAULT_INFANTS_COUNT,
    aviaClass: DEFAULT_AVIA_CLASS,
};

export default createReducer<IAviaSearchFormValues, TAviaSearchFormActions>(
    INITIAL_STATE,
)
    .handleAction(setAviaSearchFormFromFieldAction, (state, {payload}) => ({
        ...state,
        [ESearchFormFieldName.FROM]: payload,
    }))
    .handleAction(setAviaSearchFormToFieldAction, (state, {payload}) => ({
        ...state,
        [ESearchFormFieldName.TO]: payload,
    }))
    .handleAction(
        setAviaSearchFormStartDateFieldAction,
        (state, {payload}) => ({
            ...state,
            [ESearchFormFieldName.START_DATE]: payload,
        }),
    )
    .handleAction(setAviaSearchFormEndDateFieldAction, (state, {payload}) => ({
        ...state,
        [ESearchFormFieldName.END_DATE]: payload,
    }))
    .handleAction(
        setAviaSearchFormIsRoundTripFieldAction,
        (state, {payload}) => ({
            ...state,
            isRoundTrip: payload,
        }),
    )
    .handleAction(setAviaSearchFormAdultsFieldAction, (state, {payload}) => ({
        ...state,
        adults: payload,
    }))
    .handleAction(setAviaSearchFormChildrenFieldAction, (state, {payload}) => ({
        ...state,
        children: payload,
    }))
    .handleAction(setAviaSearchFormInfantsFieldAction, (state, {payload}) => ({
        ...state,
        infants: payload,
    }))
    .handleAction(
        setAviaSearchFormAviaClassFieldAction,
        (state, {payload}) => ({
            ...state,
            aviaClass: payload,
        }),
    );
