import {Dispatch} from 'redux';
import {batchActions} from 'redux-batched-actions';

import {IAviaSearchFormValues} from 'projects/avia/components/SearchForm/types';

import {isOutdated} from 'projects/avia/lib/previousSearches';

import {
    setAviaSearchFormAdultsFieldAction,
    setAviaSearchFormAviaClassFieldAction,
    setAviaSearchFormInfantsFieldAction,
    setAviaSearchFormChildrenFieldAction,
    setAviaSearchFormEndDateFieldAction,
    setAviaSearchFormFromFieldAction,
    setAviaSearchFormIsRoundTripFieldAction,
    setAviaSearchFormStartDateFieldAction,
    setAviaSearchFormToFieldAction,
} from '../actions';

export function applyPreviousSearchAction(
    previousSearch: IAviaSearchFormValues,
) {
    return function (dispatch: Dispatch): void {
        dispatch(
            batchActions([
                setAviaSearchFormFromFieldAction(previousSearch.from),
                setAviaSearchFormToFieldAction(previousSearch.to),
                setAviaSearchFormStartDateFieldAction(
                    isOutdated(previousSearch)
                        ? null
                        : previousSearch.startDate,
                ),
                setAviaSearchFormEndDateFieldAction(
                    // не заполняем endDate если протухла startDate
                    isOutdated(previousSearch) ? null : previousSearch.endDate,
                ),
                setAviaSearchFormIsRoundTripFieldAction(
                    previousSearch.isRoundTrip,
                ),
                setAviaSearchFormAdultsFieldAction(previousSearch.adults),
                setAviaSearchFormChildrenFieldAction(previousSearch.children),
                setAviaSearchFormInfantsFieldAction(previousSearch.infants),
                setAviaSearchFormAviaClassFieldAction(previousSearch.aviaClass),
            ]),
        );
    };
}
