import {batchActions} from 'redux-batched-actions';

import {EAviaSuggestsApiItemType} from 'server/api/AviaSuggestsApi/types/TAviaGetSuggestsApiResponse';
import {IPointInfo} from 'server/api/TransformSearchApi/types/IPointInfo';
import {ITransformSearchContextRequestParams} from 'server/api/TransformSearchApi/types/ITransformSearchContextRequestParams';
import {IAviaSearchFormPointField} from 'projects/avia/components/SearchForm/types';
import {ITransformSearchContextResponse} from 'server/api/TransformSearchApi/types/ITransformSearchContextResponse';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {
    setAviaSearchFormEndDateFieldAction,
    setAviaSearchFormFromFieldAction,
    setAviaSearchFormIsRoundTripFieldAction,
    setAviaSearchFormStartDateFieldAction,
    setAviaSearchFormToFieldAction,
} from 'reducers/avia/searchForm/actions';

import {ESuggestSource} from 'components/SearchSuggest/SearchSuggest';

import {crossSearchProvider} from 'serviceProvider/common/crossSearch/crossSearchProvider';

const getAviaSuggestFromPointInfo = (
    pointInfo: IPointInfo,
): IAviaSearchFormPointField => {
    return {
        inputValue: pointInfo.title,
        source: ESuggestSource.CROSS_SEARCH,
        selectedValue: {
            type: EAviaSuggestsApiItemType.CITY,
            title: pointInfo.title,
            pointCode: '',
            pointKey: pointInfo.pointKey ?? '',
            countryTitle: pointInfo.countryTitle,
            cityTitle: pointInfo.title,
            regionTitle: pointInfo.regionTitle ?? '',
            isUniqueTitle: true,
        },
    };
};

export const transformSearchContext = (
    params: Omit<ITransformSearchContextRequestParams, 'vertical'>,
): CustomThunkAction<Promise<ITransformSearchContextResponse>> => {
    return async (dispatch): Promise<ITransformSearchContextResponse> => {
        dispatch(
            batchActions([
                setAviaSearchFormFromFieldAction({
                    selectedValue: false,
                    inputValue: '',
                    source: ESuggestSource.CROSS_SEARCH,
                }),
                setAviaSearchFormToFieldAction({
                    selectedValue: false,
                    inputValue: '',
                    source: ESuggestSource.CROSS_SEARCH,
                }),
                setAviaSearchFormStartDateFieldAction(null),
                setAviaSearchFormEndDateFieldAction(null),
                setAviaSearchFormIsRoundTripFieldAction(false),
            ]),
        );

        const crossSearchInfo = await crossSearchProvider
            .provider()
            .transformSearchContext({
                ...params,
                vertical: 'avia',
            });

        const {from, to, dateForward, dateBackward} = crossSearchInfo;

        const fromFieldValue: IAviaSearchFormPointField = from
            ? getAviaSuggestFromPointInfo(from)
            : {
                  selectedValue: false,
                  inputValue: '',
                  source: ESuggestSource.INPUT,
              };
        const toFieldValue: IAviaSearchFormPointField = to
            ? getAviaSuggestFromPointInfo(to)
            : {
                  selectedValue: false,
                  inputValue: '',
                  source: ESuggestSource.INPUT,
              };

        dispatch(
            batchActions([
                setAviaSearchFormFromFieldAction(fromFieldValue),
                setAviaSearchFormToFieldAction(toFieldValue),
                setAviaSearchFormStartDateFieldAction(dateForward ?? null),
                ...(dateBackward
                    ? [
                          setAviaSearchFormEndDateFieldAction(
                              dateBackward ?? null,
                          ),
                          setAviaSearchFormIsRoundTripFieldAction(true),
                      ]
                    : []),
            ]),
        );

        return crossSearchInfo;
    };
};
