import {ActionType, createAsyncAction} from 'typesafe-actions';

import {ESearchFormFieldName} from 'components/SearchForm/types';
import {IAviaSuggest} from 'types/avia/suggests/IAviaSuggest';

export interface IAviaGetSearchSuggestsActionRequestParams {
    query: string;
    otherPoint: string;
    clientCity?: number;
}

export const getSearchSuggestsActions = createAsyncAction(
    'AVIA.SEARCH_SUGGESTS.REQUEST',
    'AVIA.SEARCH_SUGGESTS.REQUEST_SUCCESS',
    'AVIA.SEARCH_SUGGESTS.REQUEST_FAILURE',
)<
    {
        fieldType: ESearchFormFieldName.FROM | ESearchFormFieldName.TO;
        requestParams: IAviaGetSearchSuggestsActionRequestParams;
    },
    {
        fieldType: ESearchFormFieldName.FROM | ESearchFormFieldName.TO;
        items: IAviaSuggest[];
    },
    {
        fieldType: ESearchFormFieldName.FROM | ESearchFormFieldName.TO;
    }
>();

const reducerActions = {
    ...getSearchSuggestsActions,
};

export type TAviaSearchSuggestsActions = ActionType<typeof reducerActions>;
