import {createReducer} from 'typesafe-actions';

import {TAsyncStore} from 'reducers/types/TAsyncStore';
import {ESearchFormFieldName} from 'components/SearchForm/types';
import {IAviaSuggest} from 'types/avia/suggests/IAviaSuggest';

import {
    getSearchSuggestsActions,
    IAviaGetSearchSuggestsActionRequestParams,
    TAviaSearchSuggestsActions,
} from 'reducers/avia/searchSuggests/actions';

export interface IAviaSearchSuggestsStore {
    [ESearchFormFieldName.FROM]: TAsyncStore<
        IAviaSuggest[],
        IAviaGetSearchSuggestsActionRequestParams
    >;
    [ESearchFormFieldName.TO]: TAsyncStore<
        IAviaSuggest[],
        IAviaGetSearchSuggestsActionRequestParams
    >;
}

const defaultFieldValue: TAsyncStore<
    IAviaSuggest[],
    IAviaGetSearchSuggestsActionRequestParams
> = {
    value: null,
    isLoading: false,
    isNotFound: false,
    requestParams: null,
    isFailed: false,
    isFetched: false,
};

const INITIAL_STATE = {
    [ESearchFormFieldName.FROM]: defaultFieldValue,
    [ESearchFormFieldName.TO]: defaultFieldValue,
};

export default createReducer<
    IAviaSearchSuggestsStore,
    TAviaSearchSuggestsActions
>(INITIAL_STATE)
    .handleAction(
        getSearchSuggestsActions.request,
        (state, {payload: {fieldType, requestParams}}) => ({
            ...state,
            [fieldType]: {
                // Оставляем предыдущее значение, чтобы саджесты не "мигали"
                value: state[fieldType].value,
                requestParams,
                isLoading: true,
                isFetched: false,
                isFailed: false,
                isNotFound: false,
            },
        }),
    )
    .handleAction(getSearchSuggestsActions.success, (state, {payload}) => {
        return {
            ...state,
            [payload.fieldType]: {
                ...state[payload.fieldType],
                value: payload.items,
                isLoading: false,
                isFetched: true,
            },
        };
    })
    .handleAction(getSearchSuggestsActions.failure, (state, {payload}) => ({
        ...state,
        [payload.fieldType]: {
            ...state[payload.fieldType],
            value: null,
            isLoading: false,
            isFetched: true,
            isFailed: true,
        },
    }));
