import {createAction, createAsyncAction} from 'typesafe-actions';

import {IInlineSearchInfo} from 'types/avia/landing/IInlineSearchInfo';
import {TSettlementKey} from 'types/PointKey';
import {IAviaGetSearchToAnywherePageApiParams} from 'server/api/AviaGatewayApi/types/IAviaGetSearchToAnywherePageApiParams';
import {IAviaGetSearchToAnywherePageApiResponse} from 'server/api/AviaGatewayApi/types/IAviaGetSearchToAnywherePageApiResponse';

const reset = createAction('avia/searchToAnywhere/reset')();

const {
    request,
    success: requestSuccess,
    failure: requestFailure,
} = createAsyncAction(
    'avia/searchToAnywhere/request',
    'avia/searchToAnywhere/requestSuccess',
    'avia/searchToAnywhere/requestFailure',
)<
    {requestParams: IAviaGetSearchToAnywherePageApiParams},
    {
        requestParams: IAviaGetSearchToAnywherePageApiParams;
        response: IAviaGetSearchToAnywherePageApiResponse;
    },
    {error: string}
>();

const {
    request: inlineSearchRequest,
    success: inlineSearchSuccess,
    failure: inlineSearchFailure,
} = createAsyncAction(
    'avia/searchToAnywhere/inlineSearchRequest',
    'avia/searchToAnywhere/inlineSearchSuccess',
    'avia/searchToAnywhere/inlineSearchFailure',
)<
    {toPoint: TSettlementKey},
    {inlineSearchInfo: IInlineSearchInfo},
    {toPoint: TSettlementKey}
>();

export {
    reset,
    request,
    requestSuccess,
    requestFailure,
    inlineSearchRequest,
    inlineSearchSuccess,
    inlineSearchFailure,
};
