import {createAction, createAsyncAction} from 'typesafe-actions';

import {IAviaGetSearchToCountryPageApiParams} from 'server/api/AviaGatewayApi/types/IAviaGetSearchToCountryPageApiParams';
import {IAviaGetSearchToCountryPageApiResponse} from 'server/api/AviaGatewayApi/types/IAviaGetSearchToCountryPageApiResponse';
import {IInlineSearchInfo} from 'types/avia/landing/IInlineSearchInfo';
import {TSettlementKey} from 'types/PointKey';

const reset = createAction('avia/searchToCountry/reset')();

const {
    request,
    success: requestSuccess,
    failure: requestFailure,
} = createAsyncAction(
    'avia/searchToCountry/request',
    'avia/searchToCountry/requestSuccess',
    'avia/searchToCountry/requestFailure',
)<
    {requestParams: IAviaGetSearchToCountryPageApiParams},
    {
        requestParams: IAviaGetSearchToCountryPageApiParams;
        response: IAviaGetSearchToCountryPageApiResponse;
        fromPointCountryTitle: string;
    },
    {error: string}
>();

const {
    request: inlineSearchRequest,
    success: inlineSearchSuccess,
    failure: inlineSearchFailure,
} = createAsyncAction(
    'avia/searchToCountry/inlineSearchRequest',
    'avia/searchToCountry/inlineSearchSuccess',
    'avia/searchToCountry/inlineSearchFailure',
)<
    {toPoint: TSettlementKey},
    {inlineSearchInfo: IInlineSearchInfo},
    {toPoint: TSettlementKey}
>();

export {
    reset,
    request,
    requestSuccess,
    requestFailure,
    inlineSearchRequest,
    inlineSearchSuccess,
    inlineSearchFailure,
};
