import {Action} from 'typesafe-actions';

import {
    DEFAULT_ADULTS_COUNT,
    DEFAULT_AVIA_CLASS,
    DEFAULT_CHILDREN_COUNT,
    DEFAULT_INFANTS_COUNT,
} from 'constants/avia';

import {EOneWay} from 'server/services/AviaSearchService/types/IAviaParams';

import {IAviaContext} from 'reducers/avia/data-types';
import {
    setAviaSearchFormAdultsFieldAction,
    setAviaSearchFormAviaClassFieldAction,
    setAviaSearchFormChildrenFieldAction,
    setAviaSearchFormEndDateFieldAction,
    setAviaSearchFormFromFieldAction,
    setAviaSearchFormInfantsFieldAction,
    setAviaSearchFormIsRoundTripFieldAction,
    setAviaSearchFormStartDateFieldAction,
    setAviaSearchFormToFieldAction,
} from 'reducers/avia/searchForm/actions';

import {ESuggestSource} from 'components/SearchSuggest/SearchSuggest';

export function getAviaSearchFormActions(
    params: Partial<IAviaContext>,
): Action[] {
    const actions: Action[] = [];

    if (params.from) {
        actions.push(
            setAviaSearchFormFromFieldAction({
                inputValue: params.from.title,
                source: ESuggestSource.SEARCH_CONTEXT,
                selectedValue: params.from,
            }),
        );
    }

    if (params.to) {
        actions.push(
            setAviaSearchFormToFieldAction({
                inputValue: params.to.title,
                source: ESuggestSource.SEARCH_CONTEXT,
                selectedValue: params.to,
            }),
        );
    }

    if (params.when) {
        actions.push(
            setAviaSearchFormStartDateFieldAction(params.when || null),
        );
    }

    if (params.return_date) {
        actions.push(
            setAviaSearchFormEndDateFieldAction(params.return_date || null),
        );
    }

    if (params.oneway) {
        actions.push(
            setAviaSearchFormIsRoundTripFieldAction(
                params.oneway === EOneWay.ROUND_TRIP,
            ),
        );
    }

    if (params.adult_seats) {
        actions.push(
            setAviaSearchFormAdultsFieldAction(
                Number(params.adult_seats) || DEFAULT_ADULTS_COUNT,
            ),
        );
    }

    if (params.children_seats) {
        actions.push(
            setAviaSearchFormChildrenFieldAction(
                Number(params.children_seats) || DEFAULT_CHILDREN_COUNT,
            ),
        );
    }

    if (params.infant_seats) {
        actions.push(
            setAviaSearchFormInfantsFieldAction(
                Number(params.infant_seats) || DEFAULT_INFANTS_COUNT,
            ),
        );
    }

    if (params.klass) {
        actions.push(
            setAviaSearchFormAviaClassFieldAction(
                params.klass || DEFAULT_AVIA_CLASS,
            ),
        );
    }

    return actions;
}
