import {TStatus} from 'server/api/AviaTicketDaemonApi/types/IAviaTDAnswer';

import {IResultAviaVariant} from 'selectors/avia/utils/denormalization/variant';

export function cleanUpOutdatedVariants(
    partners: Record<string, TStatus>,
    variants: Record<string, IResultAviaVariant>,
    variantGroups: Record<string, string[]>,
): void {
    Object.keys(variants).forEach(tag => {
        const {key, price} = variants[tag];

        if (partners[price.partner.code] === 'outdated') {
            delete variants[tag];
            variantGroups[key] = variantGroups[key].filter(t => t !== tag);

            if (variantGroups[key].length === 0) {
                delete variantGroups[key];
            }
        }
    });
}
