import assign from 'lodash/fp/assign';

import {INormalizedTDReference} from './normalizeTDReference';

export function mergeReferences(
    stateReference: INormalizedTDReference,
    newReference: INormalizedTDReference,
): INormalizedTDReference {
    const {
        alliances,
        aviaCompanies,
        baggageTariffs,
        companies,
        companyTariffs,
        flights,
        partners,
        ratings,
        reviewsCount,
        settlements,
        stations,
        fareFamilies,
    } = newReference;

    return {
        aviaCompanies: assign(stateReference.aviaCompanies, aviaCompanies),
        companies: assign(stateReference.companies, companies),
        alliances: assign(stateReference.alliances, alliances),
        baggageTariffs: assign(stateReference.baggageTariffs, baggageTariffs),
        companyTariffs: assign(stateReference.companyTariffs, companyTariffs),
        flights: assign(stateReference.flights, flights),
        partners: assign(stateReference.partners, partners),
        reviewsCount: assign(stateReference.reviewsCount, reviewsCount),
        ratings: assign(stateReference.ratings, ratings),
        settlements: assign(stateReference.settlements, settlements),
        stations: assign(stateReference.stations, stations),
        fareFamilies: assign(stateReference.fareFamilies, fareFamilies),
    };
}
