import {
    IAviaTDAnswer,
    IProgress,
    TStatus,
} from 'server/api/AviaTicketDaemonApi/types/IAviaTDAnswer';

import {
    normalizeTDReference,
    INormalizedTDReference,
} from './normalizeTDReference';
import {normalizeTDVariants, TNormalizedFares} from './normalizeTDVariants';

export interface INormalizedTDAnswer {
    reference: INormalizedTDReference;
    variants: TNormalizedFares;
    cont: number | null;
    progress: IProgress;
    partners: Record<string, TStatus>;
}

export function normalizeTDAnswer(
    tdAnswer: IAviaTDAnswer,
): INormalizedTDAnswer {
    const {reference, variants, cont, progress, partners = {}} = tdAnswer;

    return {
        reference: normalizeTDReference(reference, partners),
        variants: normalizeTDVariants(variants),
        cont,
        progress,
        partners,
    };
}
