import {groupBy} from 'lodash';

import {
    IVariants,
    IFare,
    IVariantPrice,
    TRoute,
} from 'server/api/AviaTicketDaemonApi/types/IAviaTDAnswer';

type TPartnerCode = string;
type TFareKey = string;

export interface INormalizedFare {
    prices: Record<TPartnerCode, IVariantPrice[]>;
    route: TRoute[];
    hybrid?: boolean;
    key: TFareKey;
}

export type TNormalizedFares = Record<TFareKey, INormalizedFare>;

export function normalizeTDVariants(variants: IVariants): TNormalizedFares {
    const fareDictionary: TNormalizedFares = {};

    for (const fare of variants.fares) {
        const fareKey = getFareKey(fare);
        const normalizedPrices = groupBy(fare.prices, 'partnerCode');

        if (fareKey in fareDictionary) {
            Object.assign(fareDictionary[fareKey].prices, normalizedPrices);
            fareDictionary[fareKey].hybrid =
                fareDictionary[fareKey].hybrid || fare.hybrid;
        } else {
            fareDictionary[fareKey] = {
                prices: normalizedPrices,
                route: fare.route,
                hybrid: fare.hybrid,
                key: getFareKey(fare),
            };
        }
    }

    return fareDictionary;
}

function getFareKey(fare: IFare): TFareKey {
    const [forward, backward] = fare.route;
    const prefix = forward.join(',');
    const suffix = backward.length ? ' ' + backward.join(',') : '';

    return prefix + suffix;
}
