import {
    IProgress,
    TStatus,
} from 'server/api/AviaTicketDaemonApi/types/IAviaTDAnswer';

import {INormalizedTDReference} from 'reducers/avia/utils/ticketDaemon/normalizeTDReference';

import {IResultAviaVariant} from 'selectors/avia/utils/denormalization/variant';

/** Ключ офера партнера */
type TVariantTag = string;
/** Ключ варианта */
type TVariantGroupKey = string;

export interface INormalizedPreparedTDAnswer {
    cont: number | null;
    progress: IProgress;
    searchIsCompleted: boolean;
    /** Оферы партнеров (offer)  */
    variants: Record<TVariantTag, IResultAviaVariant>;
    /** Вариант (variant) - карточка/сниппет на выдаче */
    variantGroups: Record<TVariantGroupKey, TVariantTag[]>;
    /** Справочники */
    reference: INormalizedTDReference;
    partners: Record<string, TStatus>;
}

export const getInitialNormalizedPreparedTDAnswer =
    (): INormalizedPreparedTDAnswer => ({
        cont: null,
        searchIsCompleted: false,
        progress: {all: 0, current: 0},
        variants: {},
        variantGroups: {},
        reference: {
            aviaCompanies: {},
            companies: {},
            alliances: {},
            baggageTariffs: {},
            companyTariffs: {},
            flights: {},
            partners: {},
            reviewsCount: {},
            ratings: {},
            settlements: {},
            stations: {},
            fareFamilies: {},
        },
        partners: {},
    });
