import {ActionType, createAction, createAsyncAction} from 'typesafe-actions';

import {IGetForecastByGeoIdResponse} from 'server/api/WeatherApi/types/IGetForecastByGeoIdResponse';

export const getAviaWeatherForecastActions = createAsyncAction(
    'avia/weatherForecast/REQUEST_DATA',
    'avia/weatherForecast/REQUEST_DATA_SUCCESS',
    'avia/weatherForecast/REQUEST_DATA_FAILURE',
)<void, IGetForecastByGeoIdResponse, unknown>();

export const resetAviaWeatherForecastAction = createAction(
    'avia/weatherForecast/RESET_DATA',
)();

export type TAviaWeatherForecastActions = ActionType<
    typeof getAviaWeatherForecastActions | typeof resetAviaWeatherForecastAction
>;
