import {createReducer} from 'typesafe-actions';

import {IWeatherForecastItem} from 'types/common/IWeatherForecastItem';
import EAsyncStatus from 'types/common/EAsyncStatus';

import {
    getAviaWeatherForecastActions,
    resetAviaWeatherForecastAction,
    TAviaWeatherForecastActions,
} from 'reducers/avia/weatherForecast/actions';

export interface IAviaWeatherForecastState {
    status: EAsyncStatus | null;
    items: IWeatherForecastItem[];
}

const INITIAL_STATE: IAviaWeatherForecastState = {
    status: null,
    items: [],
};

export default createReducer<
    IAviaWeatherForecastState,
    TAviaWeatherForecastActions
>(INITIAL_STATE)
    .handleAction(getAviaWeatherForecastActions.request, state => ({
        ...state,
        status: EAsyncStatus.LOADING,
        items: [],
    }))
    .handleAction(
        getAviaWeatherForecastActions.success,
        (state, {payload}) => ({
            ...state,
            status: EAsyncStatus.SUCCESS,
            items: payload.data.items,
        }),
    )
    .handleAction(getAviaWeatherForecastActions.failure, state => ({
        ...state,
        status: EAsyncStatus.ERROR,
        items: [],
    }))
    .handleAction(resetAviaWeatherForecastAction, () => INITIAL_STATE);
