import moment from 'moment';

import {Request} from '@yandex-data-ui/core/lib/types';
import {IGetForecastByGeoIdResponse} from 'server/api/WeatherApi/types/IGetForecastByGeoIdResponse';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {getAviaWeatherForecastActions} from 'reducers/avia/weatherForecast/actions';

import {weatherService} from 'serviceProvider';

export const getWeatherForecast = (
    req?: Request,
): CustomThunkAction<Promise<void>> => {
    return async (dispatch, getState): Promise<void> => {
        const {avia} = getState();
        const {aviaContext, aviaPointsData} = avia;

        const toSettlement = aviaPointsData.to?.settlement;

        if (!toSettlement) {
            return;
        }

        const geoId = toSettlement.geoId;
        const startDate = aviaContext.when;

        const days = aviaContext.return_date
            ? moment(aviaContext.return_date).diff(
                  moment(aviaContext.when),
                  'days',
              ) + 1
            : 5;

        try {
            dispatch(getAviaWeatherForecastActions.request());

            const data: IGetForecastByGeoIdResponse = await weatherService
                .provider(req?.container)
                .getWeatherForecastByGeoId({
                    geoId,
                    startDate,
                    days,
                });

            dispatch(getAviaWeatherForecastActions.success(data));
        } catch (e) {
            dispatch(getAviaWeatherForecastActions.failure(e));
        }
    };
};
