import {ActionType, createAction} from 'typesafe-actions';

import {
    EBusesOrderError,
    EOrderPollingStatus,
} from 'reducers/buses/book/order/types';
import {IGenericOrderInfo} from 'server/api/GenericOrderApi/types/common/IGenericOrderInfo';

export const setOrderAction = createAction(
    'BUSES.BOOK.ORDER.VALUE.SET',
)<IGenericOrderInfo | null>();

export const setOrderPollingStatusAction = createAction(
    'BUSES.BOOK.ORDER.POLLING_STATUS.SET',
)<EOrderPollingStatus>();

export const setOrderErrorAction = createAction(
    'BUSES.BOOK.ORDER.ERROR.SET',
)<EBusesOrderError | null>();

const actions = {
    setOrderAction,
    setOrderPollingStatusAction,
    setOrderErrorAction,
};

export type TBusesOrderActions = ActionType<typeof actions>;
