import {createReducer} from 'typesafe-actions';

import {
    EOrderPollingStatus,
    TBusesBookOrderStore,
} from 'reducers/buses/book/order/types';

import {
    setOrderAction,
    setOrderErrorAction,
    setOrderPollingStatusAction,
    TBusesOrderActions,
} from 'reducers/buses/book/order/actions';

const INITIAL_STATE: TBusesBookOrderStore = {
    value: null,
    pollingStatus: EOrderPollingStatus.STOPPED,
    error: null,
};

export default createReducer<TBusesBookOrderStore, TBusesOrderActions>(
    INITIAL_STATE,
)
    .handleAction(setOrderPollingStatusAction, (state, {payload}) => ({
        ...state,
        pollingStatus: payload,
    }))
    .handleAction(setOrderAction, (state, {payload}) => ({
        ...state,
        value: payload,
    }))
    .handleAction(setOrderErrorAction, (state, {payload}) => ({
        ...state,
        error: payload,
    }));
