import {ActionType, createAsyncAction, createAction} from 'typesafe-actions';

import {TBusesCreateRideOfferApiResponse} from 'server/api/BusesTravelApi/types/TBusesCreateRideOfferApiResponse';
import {IBusesCreateRideOfferBrowserProviderParams} from 'serviceProvider/buses/types/IBusesCreateRideOfferBrowserProviderParams';

export const createRideOfferActions = createAsyncAction(
    'BUSES.BOOK.RIDE_OFFER.REQUEST',
    'BUSES.BOOK.RIDE_OFFER.REQUEST_SUCCESS',
    'BUSES.BOOK.RIDE_OFFER.REQUEST_FAILURE',
)<
    IBusesCreateRideOfferBrowserProviderParams,
    TBusesCreateRideOfferApiResponse,
    undefined
>();

export const changeRequestParams = createAction(
    'BUSES.BOOK.RIDE_OFFER.CHANGE_REQUEST_PARAMS',
)<IBusesCreateRideOfferBrowserProviderParams>();

const actions = {
    createRideOfferActions,
    changeRequestParams,
};

export type TBusesRideOfferActions = ActionType<typeof actions>;
