import {createReducer} from 'typesafe-actions';

import {TBusesRideOfferStore} from 'reducers/buses/types/book/TBusesRideOfferStore';
import {EMPTY_ASYNC_STATE} from 'reducers/types/TAsyncStore';

import {
    changeRequestParams,
    createRideOfferActions,
    TBusesRideOfferActions,
} from 'reducers/buses/book/rideOffer/actions';

const INITIAL_STATE: TBusesRideOfferStore = EMPTY_ASYNC_STATE;

export default createReducer<TBusesRideOfferStore, TBusesRideOfferActions>(
    INITIAL_STATE,
)
    .handleAction(createRideOfferActions.request, (state, {payload}) => ({
        ...state,
        value: null,
        requestParams: payload,
        isLoading: true,
        isFetched: false,
        isFailed: false,
        isNotFound: false,
    }))
    .handleAction(createRideOfferActions.success, (state, {payload}) => ({
        ...state,
        value: payload,
        isLoading: false,
        isFetched: true,
        isFailed: false,
        isNotFound: false,
    }))
    .handleAction(createRideOfferActions.failure, state => ({
        ...state,
        value: null,
        isLoading: false,
        isFetched: true,
        isFailed: true,
        isNotFound: false,
    }))
    .handleAction(
        changeRequestParams,
        (state, {payload}) =>
            ({
                ...state,
                requestParams: payload,
            } as TBusesRideOfferStore),
    );
