import times from 'lodash/times';

import {EBusesTicketType} from 'types/buses/booking/IBusesBookParams';
import {
    EBusesPassengerFormFiled,
    IBusesPassenger,
} from 'types/buses/booking/IBusesBookFormValues';
import {IBusesCreateOrderTicketParams} from 'server/api/GenericOrderApi/types/common/ICreateBusesServiceParams';
import {ICountry} from 'types/common/ICountry';

import preparePassenger from 'reducers/buses/book/thunk/createOrRestoreOrderAction/utilities/preparePassengers';

export default function getTickets(
    passengers: IBusesPassenger[],
    citizenships: ICountry[],
    places: string[],
): IBusesCreateOrderTicketParams[] {
    return passengers.reduce<IBusesCreateOrderTicketParams[]>(
        (accTickets, passenger, index) => {
            const preparedPassenger = preparePassenger(passenger, citizenships);

            const tariff = passenger[EBusesPassengerFormFiled.TARIFF];

            if (!tariff) {
                throw new Error('Нет тарифа');
            }

            accTickets.push({
                passenger: preparedPassenger,
                ticketType: tariff,
                seat: places[index],
            });

            const baggageCount =
                Number(passenger[EBusesPassengerFormFiled.BAGGAGE_COUNT]) || 0;

            times(baggageCount, () => {
                accTickets.push({
                    passenger: preparedPassenger,
                    ticketType: EBusesTicketType.BAGGAGE,
                });
            });

            return accTickets;
        },
        [],
    );
}
