import IContactInfo from 'server/api/GenericOrderApi/types/common/IContactInfo';

import {TBookingContacts} from 'components/BookingContactsForm/BookingContactsForm';

export default function prepareContacts(
    contacts: TBookingContacts,
): IContactInfo {
    const {email, phone} = contacts;

    if (!email || !phone) {
        throw new Error('Создание заказа: неверные контактные данные');
    }

    return {
        email,
        phone,
    };
}
