import moment from 'moment';

import {IBusesPassenger} from 'types/buses/booking/IBusesBookFormValues';
import {ICountry} from 'types/common/ICountry';
import {IBusesCreateOrderPassengerParams} from 'server/api/GenericOrderApi/types/common/ICreateBusesServiceParams';

import {HUMAN_DATE_RU, ROBOT} from 'utilities/dateUtils/formats';

export default function preparePassenger(
    passenger: IBusesPassenger,
    citizenships: ICountry[],
): IBusesCreateOrderPassengerParams {
    const {
        firstName,
        lastName,
        patronymicName,
        sex,
        birthdate,
        documentType,
        documentNumber,
        citizenship,
    } = passenger;

    const country = citizenships.find(({code2}) => code2 === citizenship);

    if (
        !firstName ||
        !lastName ||
        !sex ||
        !birthdate ||
        !documentType ||
        !documentNumber ||
        !country
    ) {
        throw new Error('Создание заказа: неверные данные пассажиров');
    }

    return {
        firstName,
        lastName,
        patronymic: patronymicName || '',
        sex,
        birthDate: moment(birthdate, HUMAN_DATE_RU).format(ROBOT),
        documentType,
        documentNumber,
        citizenship: country.geoId,
    };
}
