import {
    INotebookSavePassengerParams,
    INotebookSaveTravelerAndPassengersServiceParams,
} from 'server/services/NotebookService/types/INotebookSaveTravelerAndPassengersService';
import IContactInfo from 'server/api/GenericOrderApi/types/common/IContactInfo';
import {IBusesCreateOrderTicketParams} from 'server/api/GenericOrderApi/types/common/ICreateBusesServiceParams';
import {EBusesTicketType} from 'types/buses/booking/IBusesBookParams';

import getTitle from 'utilities/notebook/getTitle';

export default function getTravelerAndPassengersSaveParams(
    contacts: IContactInfo,
    tickets: IBusesCreateOrderTicketParams[],
): INotebookSaveTravelerAndPassengersServiceParams {
    return {
        traveler: {
            phone: contacts.phone,
            email: contacts.email,
            agree: true,
        },
        passengers: tickets
            .filter(ticket => ticket.ticketType !== EBusesTicketType.BAGGAGE)
            .map((ticket): INotebookSavePassengerParams => {
                const {passenger} = ticket;

                return {
                    title: getTitle(
                        passenger.firstName,
                        passenger.lastName,
                        passenger.patronymic,
                    ),
                    gender: passenger.sex,
                    birthDate: passenger.birthDate,
                    document: {
                        type: passenger.documentType,
                        number: passenger.documentNumber,
                        citizenship: passenger.citizenship,
                        firstName: passenger.firstName,
                        lastName: passenger.lastName,
                        middleName: passenger.patronymic,
                    },
                    bonusCards: [],
                };
            }),
    };
}
