import IContactInfo from 'server/api/GenericOrderApi/types/common/IContactInfo';
import {IBusesCreateOrderTicketParams} from 'server/api/GenericOrderApi/types/common/ICreateBusesServiceParams';

import getTravelerAndPassengersSaveParams from 'reducers/buses/book/thunk/createOrRestoreOrderAction/utilities/saveTravelerAndPassengers/getTravelerAndPassengersSaveParams';

import {logError} from 'utilities/logger/logError';

import {notebookBrowserProvider} from 'serviceProvider/notebook/notebookBrowserProvider';

export default async function saveTravelerAndPassengers(
    contacts: IContactInfo,
    tickets: IBusesCreateOrderTicketParams[],
): Promise<void> {
    try {
        await notebookBrowserProvider.saveTravelerAndPassengers(
            getTravelerAndPassengersSaveParams(contacts, tickets),
        );
    } catch (err) {
        logError(
            {
                message: '[YATRAVEL][BUSES] Сохранение данных в ЗКП',
            },
            err,
        );
    }
}
