import EGenericOrderState from 'server/api/GenericOrderApi/types/common/EGenericOrderState';
import {IBusCurrentStoredOrderInfo} from 'projects/buses/applications/BookApp/utilities/currentStoredOrder/types';
import {EBusesGoal} from 'utilities/metrika/types/goals/buses';

import getCurrentStoredOrderInfo from 'projects/buses/applications/BookApp/utilities/currentStoredOrder/getCurrentStoredOrderInfo';
import tryCancelStoredOrder from 'projects/buses/applications/BookApp/utilities/tryCancelStoredOrder';
import {reachGoal} from 'utilities/metrika';

import {genericOrderBrowserProvider} from 'serviceProvider/genericOrder/genericOrderBrowserProvider';

/**
 * Пытаемся перейти на уже созданный до этого момента, активный заказ, если пользователь не поменял данные.
 */
export default async function tryRestoreOrder(
    createOrderParams: IBusCurrentStoredOrderInfo['createParams'],
): Promise<string | null> {
    const currentStoredOrderInfo = getCurrentStoredOrderInfo();

    if (!currentStoredOrderInfo) {
        return null;
    }

    const {state} = await genericOrderBrowserProvider.getOrderState({
        orderId: currentStoredOrderInfo.id,
    });

    if (
        JSON.stringify(createOrderParams) ===
        JSON.stringify(currentStoredOrderInfo.createParams)
    ) {
        if (state !== EGenericOrderState.CANCELLED) {
            reachGoal(EBusesGoal.BOOK_PAGE_BOOK_WITH_STORED_ORDER);

            return currentStoredOrderInfo.id;
        }

        return null;
    }

    await tryCancelStoredOrder(state);

    return null;
}
