import EGenericOrderState from 'server/api/GenericOrderApi/types/common/EGenericOrderState';
import {EBusesOrderError} from 'reducers/buses/book/order/types';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {
    setOrderAction,
    setOrderErrorAction,
} from 'reducers/buses/book/order/actions';
import startPaymentAction from 'reducers/buses/book/thunk/startPaymentAction';

import orderSelector from 'selectors/buses/book/orderSelector';

import {logError} from 'utilities/logger/logError';

export default function hidePaymentErrorAndStartPaymentAction({
    orderId,
}: {
    orderId: string;
}): CustomThunkAction<void> {
    return async (dispatch, getState): Promise<void> => {
        try {
            const order = orderSelector(getState());

            if (!order) {
                return;
            }

            dispatch(
                setOrderAction({
                    ...order,
                    state: EGenericOrderState.STARTING_PAYMENT,
                    payment: null,
                }),
            );

            await dispatch(startPaymentAction({orderId}));
        } catch (err) {
            dispatch(setOrderErrorAction(EBusesOrderError.COMMON));

            logError(
                {
                    message: '[YATRAVEL][BUSES] Рестарт оплаты',
                },
                err,
            );
        }
    };
}
