import {Request} from '@yandex-data-ui/core/lib/types';
import {EBusesGoal} from 'utilities/metrika/types/goals/buses';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import requestContextAction from 'reducers/buses/context/thunk/requestContextAction';
import fillSearchFormThunkAction from 'reducers/buses/search/thunk/fillSearchFormThunkAction';
import createRideOfferAction from 'reducers/buses/book/rideOffer/thunk/createRideOfferAction';
import {fetchPassengers} from 'reducers/common/passengers/thunk';

import {contextSelector} from 'selectors/buses/context/contextSelector';
import rideOfferSelector from 'selectors/buses/book/rideOfferSelector';

import {logError} from 'utilities/logger/logError';
import {restoreYtpReferer} from 'utilities/ytpReferer';
import {reachGoal} from 'utilities/metrika';
import hasSchema from 'projects/buses/pages/booking/BookPage/components/LeftColumn/components/Places/components/SchemaInfo/utilities/hasSchema';

export default function requestBookPageInfoAction({
    req,
    params,
    isSSR,
}: {
    req?: Request;
    params: {
        rideId: string;
        from: string;
        to: string;
        when: string;
    };
    isSSR: boolean;
}): CustomThunkAction<void> {
    return async (dispatch, getState): Promise<void> => {
        try {
            const {rideId, from, to, when} = params;

            await Promise.all([
                (async (): Promise<void> => {
                    await dispatch(
                        requestContextAction({
                            req,
                            params: {
                                fromSlug: from,
                                toSlug: to,
                                when,
                            },
                        }),
                    );

                    const context = contextSelector(getState());

                    if (!context) {
                        return;
                    }

                    dispatch(fillSearchFormThunkAction(context));
                })(),
                !isSSR &&
                    dispatch(
                        createRideOfferAction({
                            rideId,
                            ytpReferer: restoreYtpReferer(),
                        }),
                    ),
                !isSSR && dispatch(fetchPassengers()),
            ]);

            const rideOfferInfo = rideOfferSelector(getState());
            const bookParams = rideOfferInfo.value?.bookParams;

            if (bookParams) {
                reachGoal(EBusesGoal.BOOK_PAGE_LOADED_SUCCESSFULLY, {
                    buses: {
                        bookPage: {
                            withSchema: hasSchema(
                                bookParams.placesMap,
                                bookParams.seats,
                            ),
                        },
                    },
                });
            }
        } catch (err) {
            reachGoal(EBusesGoal.BOOK_PAGE_LOADED_WITH_ERROR);

            logError(
                {
                    message:
                        '[YATRAVEL][BUSES] Загрузка данных для страницы бронирования',
                },
                err,
            );
        }
    };
}
