import {URLs} from 'constants/urls';

import EDeviceType from 'server/api/GenericOrderApi/types/common/EDeviceType';

import {CustomThunkAction} from 'reducers/trains/customDispatch';

import deviceTypeSelector from 'selectors/common/deviceTypeSelector';

import getFinishPaymentUrl from 'utilities/url/getFinishPaymentUrl';

import {genericOrderBrowserProvider} from 'serviceProvider/genericOrder/genericOrderBrowserProvider';

export default function startPaymentAction({
    orderId,
}: {
    orderId: string;
}): CustomThunkAction<void> {
    return async (dispatch, getState): Promise<void> => {
        const deviceType = deviceTypeSelector(getState());

        await genericOrderBrowserProvider.startPayment({
            orderId,
            returnUrl: getFinishPaymentUrl(URLs.busesBookFinishPayment),
            source: deviceType.isMobile
                ? EDeviceType.MOBILE
                : EDeviceType.DESKTOP,
        });
    };
}
