import {batchActions} from 'redux-batched-actions';

import {EOrderPollingStatus} from 'reducers/buses/book/order/types';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {
    setOrderAction,
    setOrderErrorAction,
    setOrderPollingStatusAction,
} from 'reducers/buses/book/order/actions';

export default function stopOrderPolling(): CustomThunkAction<void> {
    return async (dispatch): Promise<void> => {
        dispatch(
            batchActions([
                setOrderAction(null),
                setOrderErrorAction(null),
                setOrderPollingStatusAction(EOrderPollingStatus.STOPPED),
            ]),
        );
    };
}
