import {ActionType, createAsyncAction} from 'typesafe-actions';

import {TBusesCalendar} from 'types/buses/search/TBusesCalendar';

export interface IGetCalendarRequestAction {
    fromPointKey: string;
    toPointKey: string;
}

export const getCalendarActions = createAsyncAction(
    'BUSES.CALENDAR.REQUEST',
    'BUSES.CALENDAR.REQUEST_SUCCESS',
    'BUSES.CALENDAR.REQUEST_FAILURE',
)<IGetCalendarRequestAction, TBusesCalendar, undefined>();

const reducerActions = {
    ...getCalendarActions,
};

export type TBusesCalendarActions = ActionType<typeof reducerActions>;
