import {createReducer} from 'typesafe-actions';

import {TBusesCalendarStore} from 'reducers/buses/types/calendar/TBusesCalendarStore';

import {
    getCalendarActions,
    TBusesCalendarActions,
} from 'reducers/buses/calendar/actions';

const INITIAL_STATE: TBusesCalendarStore = {
    value: null,
    requestParams: null,
    isLoading: false,
    isFetched: false,
    isFailed: false,
    isNotFound: false,
};

export default createReducer<TBusesCalendarStore, TBusesCalendarActions>(
    INITIAL_STATE,
)
    .handleAction(getCalendarActions.request, (state, {payload}) => ({
        value: null,
        requestParams: payload,
        isLoading: true,
        isFetched: false,
        isFailed: false,
        isNotFound: false,
    }))
    .handleAction(getCalendarActions.success, (state, {payload}) => ({
        value: payload,
        requestParams: state.requestParams,
        isLoading: false,
        isFetched: true,
        isFailed: false,
        isNotFound: false,
    }))
    .handleAction(getCalendarActions.failure, state => ({
        value: null,
        requestParams: state.requestParams,
        isLoading: false,
        isFetched: true,
        isFailed: true,
        isNotFound: false,
    }));
