import moment from 'moment';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {
    getCalendarActions,
    IGetCalendarRequestAction,
} from 'reducers/buses/calendar/actions';

import {formatDate, getNow} from 'utilities/dateUtils';
import requestCalendar from 'projects/buses/utilities/api/requestCalendar';
import {ROBOT} from 'utilities/dateUtils/formats';

const CALENDAR_DAYS_WIDTH = 28;

export default function requestCalendarThunkAction({
    fromPointKey,
    toPointKey,
}: IGetCalendarRequestAction): CustomThunkAction<Promise<void>> {
    return async (dispatch, getState): Promise<void> => {
        try {
            const {
                buses: {
                    calendar: {requestParams: prevRequestParams},
                },
            } = getState();

            if (
                prevRequestParams?.fromPointKey === fromPointKey &&
                prevRequestParams.toPointKey === toPointKey
            ) {
                return;
            }

            dispatch(
                getCalendarActions.request({
                    fromPointKey,
                    toPointKey,
                }),
            );

            const now = moment(getNow());

            const calendar = await requestCalendar({
                fromPointKey,
                toPointKey,
                minDate: formatDate(now, ROBOT),
                maxDate: formatDate(
                    moment(now).add(CALENDAR_DAYS_WIDTH, 'days'),
                    ROBOT,
                ),
            });

            dispatch(getCalendarActions.success(calendar));
        } catch (err) {
            dispatch(getCalendarActions.failure());
        }
    };
}
