import {createReducer} from 'typesafe-actions';

import {IBusesCityPointStore} from 'reducers/buses/types/city/IBusesCityPointStore';

import {getCityPointActions, TBusesCityPointActions} from './actions';

const INITIAL_STATE: IBusesCityPointStore = {
    value: null,
    isLoading: false,
    isFetched: false,
    error: false,
    errorStatus: null,
};

export default createReducer<IBusesCityPointStore, TBusesCityPointActions>(
    INITIAL_STATE,
)
    .handleAction(getCityPointActions.request, state => ({
        ...state,
        value: null,
        isLoading: true,
        isFetched: false,
        error: false,
        errorStatus: null,
    }))
    .handleAction(getCityPointActions.success, (state, {payload}) => ({
        ...state,
        value: payload,
        isLoading: false,
        isFetched: true,
    }))
    .handleAction(getCityPointActions.failure, (state, {payload}) => ({
        ...state,
        value: null,
        isLoading: false,
        error: true,
        errorStatus: payload,
        isFetched: true,
    }));
