import {Request} from '@yandex-data-ui/core/lib/types';
import {isFilledContextPoint} from 'types/buses/common/IBusesContext';
import {EHttpStatusCodes} from 'types/httpStatusCodes';

import {CustomThunkAction} from 'reducers/trains/customDispatch';

import requestContext from 'projects/buses/utilities/api/requestContext';
import isAxiosError from 'utilities/api/isAxiosError';

import {getCityPointActions} from '../actions';

export default function requestCityPointThunkAction(
    slug: string,
    req?: Request,
): CustomThunkAction<void> {
    return async (dispatch, getState): Promise<void> => {
        try {
            const {
                buses: {
                    city: {point},
                },
            } = getState();

            if (point.value && point.value.slug === slug) {
                return;
            }

            dispatch(getCityPointActions.request());

            const {from} = await requestContext({
                req,
                params: {fromSlug: slug},
            });

            if (!isFilledContextPoint(from)) {
                dispatch(
                    getCityPointActions.failure(EHttpStatusCodes.NotFound),
                );

                return;
            }

            dispatch(getCityPointActions.success(from));
        } catch (err) {
            const status = isAxiosError(err) ? err.response?.status : undefined;

            dispatch(
                getCityPointActions.failure(
                    status ?? EHttpStatusCodes.InternalServerError,
                ),
            );
        }
    };
}
