import {Request} from '@yandex-data-ui/core/lib/types';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {setBusesSearchFormFromFieldAction} from 'reducers/buses/searchForm/actions';

import {getPointData} from 'projects/buses/utilities/search/getPointData';

import {ESuggestSource} from 'components/SearchSuggest/SearchSuggest';

import requestCityPointThunkAction from '../point/thunk/requestCityPointThunkAction';

export default function initCityPageThunkAction(
    slug: string,
    req?: Request,
): CustomThunkAction<void> {
    return async (dispatch, getState): Promise<void> => {
        await dispatch(requestCityPointThunkAction(slug, req));

        const {
            buses: {
                city: {
                    point: {value: city},
                },
            },
        } = getState();

        if (!city) {
            return;
        }

        dispatch(
            setBusesSearchFormFromFieldAction({
                inputValue: city.title,
                source: ESuggestSource.SEARCH_CONTEXT,
                selectedValue: getPointData(city),
            }),
        );
    };
}
