import {ActionType, createAction, createAsyncAction} from 'typesafe-actions';

import {IBusesFilledContext} from 'types/buses/common/IBusesContext';

import {IBusesRequestContextParams} from 'projects/buses/utilities/api/requestContext';

export const getContextActions = createAsyncAction(
    'BUSES.CONTEXT.REQUEST',
    'BUSES.CONTEXT.REQUEST_SUCCESS',
    'BUSES.CONTEXT.REQUEST_FAILURE',
)<IBusesRequestContextParams, IBusesFilledContext, undefined>();

export const setContextValueAction =
    createAction('BUSES.CONTEXT.SET')<IBusesFilledContext>();

const reducerActions = {
    ...getContextActions,
    setContextValueAction,
};

export type TBusesContextActions = ActionType<typeof reducerActions>;
