import {createReducer} from 'typesafe-actions';

import {TBusesContextStore} from 'reducers/buses/types/contex/TBusesContextStore';
import {EMPTY_ASYNC_STATE} from 'reducers/types/TAsyncStore';

import {
    getContextActions,
    setContextValueAction,
    TBusesContextActions,
} from 'reducers/buses/context/actions';

const INITIAL_STATE: TBusesContextStore = EMPTY_ASYNC_STATE;

export default createReducer<TBusesContextStore, TBusesContextActions>(
    INITIAL_STATE,
)
    .handleAction(setContextValueAction, (state, {payload}) => ({
        value: payload,
        requestParams: state.requestParams,
        isLoading: false,
        isFetched: true,
        isFailed: false,
        isNotFound: false,
    }))
    .handleAction(getContextActions.request, (state, {payload}) => ({
        value: null,
        requestParams: payload,
        isLoading: true,
        isFetched: false,
        isFailed: false,
        isNotFound: false,
    }))
    .handleAction(getContextActions.success, (state, {payload}) => ({
        ...state,
        value: payload,
        isLoading: false,
        isFetched: true,
        isFailed: false,
        isNotFound: false,
    }))
    .handleAction(getContextActions.failure, state => ({
        ...state,
        value: null,
        isLoading: false,
        isFetched: true,
        isFailed: true,
        isNotFound: false,
    }));
