import {createReducer} from 'typesafe-actions';

import EAsyncStatus from 'types/common/EAsyncStatus';
import {IBusesFilledContext} from 'types/buses/common/IBusesContext';
import {TDirectionPageBlock} from 'types/buses/direction/TDirectionPageBlock';

import prepareContext from './utilities/prepareContext';

import {
    fetchBusesDirectionPageActions,
    TBusesDirectionPageFetchActions,
} from './actions';

export interface IBusesDirectionPageStore {
    status: EAsyncStatus;
    data?: {
        context: IBusesFilledContext;
        blocks: TDirectionPageBlock[];
    };
}

const INITIAL_STATE: IBusesDirectionPageStore = {
    status: EAsyncStatus.INITIAL,
};

export default createReducer<
    IBusesDirectionPageStore,
    TBusesDirectionPageFetchActions
>(INITIAL_STATE)
    .handleAction(fetchBusesDirectionPageActions.request, state => ({
        ...state,
        status: EAsyncStatus.LOADING,
    }))
    .handleAction(
        fetchBusesDirectionPageActions.success,
        (state, {payload}) => ({
            data: {
                ...payload,
                context: prepareContext(payload.context),
            },
            status: EAsyncStatus.SUCCESS,
        }),
    )
    .handleAction(fetchBusesDirectionPageActions.failure, state => ({
        ...state,
        status: EAsyncStatus.ERROR,
    }));
