import {Request} from '@yandex-data-ui/core/lib/types';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {fetchBusesDirectionPageActions} from 'reducers/buses/directionPage/actions';
import fillSearchFormThunkAction from 'reducers/buses/search/thunk/fillSearchFormThunkAction';

import {busesService} from 'serviceProvider';

export function fetchDirectionPageInfo(
    fromSlug: string,
    toSlug: string,
    req?: Request,
): CustomThunkAction<void> {
    return async (dispatch, getState): Promise<void> => {
        try {
            await dispatch(fetchBusesDirectionPageActions.request());

            const direction = await busesService
                .provider(req?.container)
                .getDirection({
                    fromSlug: fromSlug,
                    toSlug: toSlug,
                });

            await dispatch(fetchBusesDirectionPageActions.success(direction));
        } catch {
            dispatch(fetchBusesDirectionPageActions.failure());
        }

        try {
            const context = getState().buses.directionPage.data?.context;

            if (!context) {
                return;
            }

            await dispatch(fillSearchFormThunkAction(context));
        } catch {}
    };
}
