import {IBusesFilledContext} from 'types/buses/common/IBusesContext';
import {IBusesContext} from 'types/buses/direction/IBusesContext';

function prepareContext(context: IBusesContext): IBusesFilledContext {
    return {
        distance: context.distance,
        from: {
            ...context.from,
            title: context.from.title.nominativeCase,
            titleAccusative: context.from.title.accusativeCase,
            titleGenitive: context.from.title.genitiveCase,
        },
        to: {
            ...context.to,
            title: context.to.title.nominativeCase,
            titleAccusative: context.to.title.accusativeCase,
            titleGenitive: context.to.title.genitiveCase,
        },
        originWhen: null,
        when: null,
        errors: [],
    };
}

export default prepareContext;
